<?php


namespace App\Http\Controllers\Admin\Auth;

use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;
use App\Http\Requests\Auth\AdminLoginRequest;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
    //  return view('admin.auth.login');
    return view('admin.auth.admin_login');
    }

 /**
     * Handle an incoming authentication request.
     */
    public function store(AdminLoginRequest $request): RedirectResponse
    {
       // dd($request);
        $request->authenticate();

        $request->session()->regenerate();

        // $notification = array(
        //     'message' => 'Admin logged inn Successfully',
        //     'alert-type' => 'success'
        // );

       // return "Admin is logged in Successfully";
     return redirect()->intended(route('admin.dashboard', absolute: false));
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('admin')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

       return redirect('/admin/login');
        // return redirect('/admin/login')->withHeaders([

        //     'Cache-Control' => 'no-cache, no-store, max-age=0, must-revalidate',

        //     'Pragma' => 'no-cache',

        //     'Expires' => 'Sat, 01 Jan 2000 00:00:00 GMT',

        // ]);
    }


}
