<?php

namespace App\Http\Controllers\Backend\FileManagement;

use Str;
use App\Models\FileCategory;
use Illuminate\Http\Request;
use App\Trait\FileManagement;
use Illuminate\Contracts\View\View;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use App\Http\Requests\Backend\FileCategoryRequest;
use App\Models\FileModel;

class FileManagementController extends Controller

{

use FileManagement;



public function fileIndex(): View
{



return view('backend.filemanager.files.view_files');

}




public function viewFiles(): View

{

    $all_files=FileModel::all();

return view('backend.filemanager.files.view_files', compact('all_files'));

}











public function index(): View

{
return view('backend.filemanager.index');

}



public function viewCategories(): View

{
    $fileCategories =FileCategory::paginate(15);
return view('backend.file_categories.view_file_category', compact('fileCategories'));

}
public function addCategory()

{
return view('backend.file_categories.add_file_category');

}



// public function storeCategory(FileCategoryRequest $request):RedirectResponse
public function storeCategory(Request $request)
{


dd ($request->all());
      //Define Image path directory either here or allow user to define
        $directory = '/uploads/images/file_category';


                // Check if new image exist in the submitted request
        if ($request->file('category_image')) {

            // create the path for new image from Trait uploadfile
           //new method using traits
           $filePath = $this->uploadImageFile($request->file('category_image'),   $directory);

        }
        // $imagePath = $this->uploadFile($request->file('category_image'));


                // If user did not select or provide Image
        if ($request->file('category_image') == null) {
            $filePath =  'uploads/images/default_images/no_image.jpg';

        }

      //  dd($filePath);
        // if we come so far, then save data including image file path
        FileCategory::insert([
            'category_name' => $request->category_name,
            'category_slug' => strtolower(str_replace(' ', '-', $request->category_name)),
            'category_image' =>  $filePath,
            'is_trending'=> $request->is_treading ?? 0,
             'status'=> $request->status ?? 0,
        ]);

        // $category = new FileManagement();
        // $category->image = $imagePath;
        // // $category->icon = $request->icon;
        // $category->name = $request->name;
        // $category->slug = Str::slug($request->category_name);
        // $category->show_at_trending = $request->is_treading ?? 0;
        // $category->status = $request->status ?? 0;
        // $category->save();

        notyf()
            ->position('x', 'center')
            ->position('y', 'top')
        ->success("File Category Created Successfully!");
      return redirect()->back();
        // return to_route('admin.course-categories.index');


}


public function edit()

{
return view('backend.filemanager.index');

}


public function delete()

{
return view('backend.filemanager.index');

}







public function viewSubCategories(): View

{
    $fileCategories =FileCategory::paginate(15);
return view('backend.file_categories.sub_category.sub_categories', compact('fileCategories'));

}
public function addSubCategory()

{
return view('backend.file_categories.add_file_category');

}


}
