<?php

namespace App\Http\Controllers\Backend\FileManagement;

use Illuminate\Http\Request;
use App\Trait\FileManagement;
use App\Http\Controllers\Controller;
use App\Models\FileModel;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Illuminate\Support\Facades\File;

class FileUploadController extends Controller
{

use FileManagement;

 public function uploadFiles(Request $request, $id){
// dd($request->file_name, $id);
  $request->validate([
        'file_name' => 'required|file|mimes:jpg,png,pdf,doc,docx,xlx,xls|max:10240', // Max file size: 10MB
    ]);

    $directory = '/uploads/files';
    $file = $request->file('file_name');

//    if(!File::isDirectory($file )){
//       $extension = $file->getClientOriginalExtension();
//     // dd('Inside'.$extension);
//
//     }

      if(File::isDirectory($file )){

    notyf()
            ->position('x', 'center')
            ->position('y', 'top')
        ->info("This is a directory");
  return redirect()->back();
    }


    $filename =  $file->getClientOriginalName();
    $extension = $file->getClientOriginalExtension();
    $file_size = $file->getSize();
    $filePath = $this->uploadFile( $file,   $directory);

// dd($file_size,   $filename, $extension);
//


             FileModel::insert([
            'sub_folder_id' => $id,
            'file_name' =>  $filename,
            'file_path' =>  $filePath,
            'file_type' =>  $extension,
            'file_size' => $file_size,
            'slug' => strtolower(str_replace(' ', '-', $filename)),

        ]);
    // $file->storeAs('uploads', $fileName); // Store file in storage/app/uploads directory
    notyf()
            ->position('x', 'center')
            ->position('y', 'top')
        ->success("File uploaded successfully");
    return redirect()->back();



 }



}
