<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->enum('role',['executive', 'ivestment', 'member'])->default('member')->comment('default value is Member');

            $table->string('last_name');
            $table->string('first_name');

            // can also login with other username in the future
           // $table->string('username')->unique();


            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->enum('email_verified_status', ['1','0'])->default('1');

            // one time code for first time login
            $table->string('code')->nullable();
            $table->string('password');

            //must have a default image, user can change image later on
            $table->string('photo')->default('/uploads/images/default_images/no_image.jpg', 2048)->nullable();
             $table->date('joined_date')->nullable();

            //User profile
            $table->date('dob')->nullable();
            $table->enum('gender',['male','female'])->nullable();
          //  $table->string('id_no');
  

            //login as user and must be able to switch
            $table->enum('login_as', ['executive','investment','member'])->default('member');
            $table->enum('status', ['active','inactive'])->default('active');
            $table->string('inactive_reason')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
