<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->id();
            $table->string('last_name');
            $table->string('first_name');
           // $table->string('username')->unique();
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->enum('email_verified_status', ['1','0'])->default('1');

            $table->string('code')->nullable();
            $table->string('password');

            $table->string('photo')->default('/uploads/images/default_images/no_image.jpg', 2048)->nullable();
            $table->date('joined_date')->nullable();
            $table->enum('role',['superadmin', 'admin'])->default('admin')->comment('default value is Admin');
            // $table->enum('status', ['1','0'])->default('1')->nullable();
            //login as user and must be able to switch
            $table->enum('login_as', ['superadmin','admin'])->default('admin');
            $table->enum('status', ['active','inactive'])->default('active');
            $table->string('inactive_reason')->nullable();

            //Admin profile
            $table->date('dob')->nullable();
            $table->enum('gender',['male','female'])->nullable();
          //  $table->string('id_no');
            $table->string('address')->nullable();
            $table->string('post_code')->nullable();
            $table->string('city')->nullable();
            $table->string('region')->nullable();
            $table->string('country')->nullable();
            $table->string('phone')->nullable();

            //File or folder

            $table->string('disignation')->nullable();
            $table->string('department')->nullable();
            $table->string('about_me')->nullable();

            $table->string('notes')->nullable();
            $table->string('document_name')->nullable()->comment('certificates, ID card, other relevant documents');
            $table->string('document_type')->nullable()->comment('pdf, jpg');
            $table->string('document_size')->nullable()->comment('file size in bytes');
            $table->string('document_url')->nullable()->comment('document path');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admins');
    }
};
