<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_profiles', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade')->comment('user_id =id on user table');

            $table->string('address')->nullable();
            $table->string('post_code')->nullable();
            $table->string('city')->nullable();
            // $table->string('region')->nullable();
            $table->string('country')->nullable();
            $table->string('phone')->nullable();

            //File or folder

            $table->string('disignation')->nullable();
            $table->string('department')->nullable();
            $table->string('about_me')->nullable();

            $table->string('notes')->nullable();
            $table->string('document_name')->nullable()->comment('certificates, ID card, other relevant documents');
            $table->string('document_type')->nullable()->comment('pdf, jpg');
            $table->string('document_size')->nullable()->comment('file size in bytes');
            $table->string('document_url')->nullable()->comment('document path');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_profiles');
    }
};
