<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('file_categories', function (Blueprint $table) {
            $table->id();
            $table->string('category_name')->unique();
            $table->string('icon')->nullable();

            $table->string('category_image')->nullable();
            $table->string('category_image_path', 2048)->nullable();

            $table->string('category_slug')->nullable();

            $table->foreignId('parent_id')->nullable();
            $table->boolean('is_trending')->default(0);
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('file_categories');
    }
};
