<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_categories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('file_category_id')->nullable();
            // $table->unsignedBigInteger('file_category_id')->nullable();
            $table->string('sub_category')->unique();
            $table->string('sub_category_slug')->nullable();
            $table->string('sub_category_image')->nullable();
            $table->string('sub_category_image_path', 2048)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_categories');
    }
};
