<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('file_management', function (Blueprint $table) {
            $table->id();
            $table->string('file_name')->nullable();
            $table->longText('description')->nullable();
            $table->unsignedBigInteger('file_category_id')->nullable();
            $table->unsignedBigInteger('sub_category_id')->nullable();

            //  $table->string('file_image')->nullable();
            $table->string('file_type')->nullable();
            $table->string('file_path')->nullable();
            $table->string('file_size')->nullable();

            $table->string('uploaded_by');
            $table->date('uploaded_date')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('file_management');
    }
};
