<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_folders', function (Blueprint $table) {
            $table->id();
            // $table->foreignId('file_folder_id')->nullable();
             $table->unsignedBigInteger('file_folder_id');
            $table->foreign('file_folder_id')->references('id')->on('file_folders');
            $table->string('sub_folder_name')->unique();
            $table->string('slug')->unique();

             $table->unique(['id','file_folder_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_folders');
    }
};
