<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('file_models', function (Blueprint $table) {
            $table->id();
             $table->unsignedBigInteger('sub_folder_id');
            $table->foreign('sub_folder_id')->references('id')->on('sub_folders');

             $table->string('file_name')->unique();
           $table->string('icon')->nullable();

            $table->string('slug')->unique();

            $table->string('file_type')->nullable();
            $table->string('file_path')->nullable();
            $table->string('file_size')->nullable();

             $table->unique(['id','sub_folder_id' ]);

            $table->string('uploaded_by')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('file_models');
    }
};
