@extends('layouts.admin.master')

@section('admin_main_body')

    <!--CDN support JQuery from w3 schools TK-- To show images-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

 <!-- Content -->
<div class="container-xxl flex-grow-1 container-p-y">

    <h4 class="py-3 breadcrumb-wrapper mb-4">
        <span class="text-muted fw-light">Profile Settings /</span> Profile Edit
    </h4>

    <div class="row">
      <div class="col-md-12">
        <div class="nav-align-top">
          <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-md-0 gap-2">
            <li class="nav-item">
              <a class="nav-link active" href="{{ route('admin.edit.profile')}}"
                ><i class="icon-base ti tabler-user icon-sm me-1_5"></i>Profile Edit</a
              >
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{ route('admin.profile.password.change')}}"
                ><i class="icon-base ti tabler-lock icon-sm me-1_5"></i> Change Password</a
              >
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{ route('admin.view.profile')}}"
                ><i class="icon-base ti tabler-bookmark icon-sm me-1_5"></i> Profile View</a
              >
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{ route('admin.dashboard')}}"
                ><i class="icon-base ti tabler-bell icon-sm me-1_5"></i> Dashboard</a
              >
            </li>
            {{-- <li class="nav-item">
              <a class="nav-link" href="pages-account-settings-connections.html"
                ><i class="icon-base ti tabler-link icon-sm me-1_5"></i> Connections</a
              >
            </li> --}}
          </ul>
        </div>


       <!--Profile Picture Account -->
       <div class="row">

       <!--Profile Picture Account -->
    <div class="card mb-6">

        <h5 class="card-header">Change Profile Photo</h5>

          <form method="post" action=""
          enctype="multipart/form-data">

          @csrf


          {{-- @if ($errors->any())
              <div class="alert alert-danger">
                  <ul>
                      @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
          @endif --}}


          <div class="card-body">
            <div class="d-flex align-items-start align-items-sm-center gap-6">
              <img id="showImage"

                src="{{ !empty($profileData->photo) ? url($profileData->photo) : url('uploads/images/default_images/no_image.jpg') }}"
               alt="user-avatar" class="d-block rounded" height="100" width="100" />

               <div class="button-wrapper">

                <label  class="btn btn-label-primary me-2 mb-4" tabindex="0">
                        <span class="">Upload new photo</span>
                        <i class="bx bx-upload d-block d-sm-none"></i>
                        <input type="file" name="photo" class="form-control" id="image"
                            hidden accept="image/png, image/jpg, image/jpeg" />
                    </label>


                    <button type="submit" class="btn btn-primary me-3">
                        <i class="bx bx-reset d-block d-sm-none"></i>
                        <span class="d-none d-sm-block">Save Changes</span>
                    </button>

                    <p class="mb-0">Allowed JPG, GIF or PNG. Max size of 800K</p>
                </div>

            </div>
          </div>
          </form>
        </div>
    </div>
        <!--Profile Picture Account -->






     <!--Profile Account -->
        <div class="card mb-6">

            <h5 class="card-header">Edit Profile</h5>
            {{-- <div class="card-body">
              <div class="d-flex align-items-start align-items-sm-center gap-6">
                <img
                  src="../../assets/img/avatars/1.png"
                  alt="user-avatar"
                  class="d-block w-px-100 h-px-100 rounded"
                  id="uploadedAvatar" />
                <div class="button-wrapper">
                  <label for="upload" class="btn btn-primary me-3 mb-4" tabindex="0">
                    <span class="d-none d-sm-block">Upload new photo</span>
                    <i class="icon-base ti tabler-upload d-block d-sm-none"></i>
                    <input
                      type="file"
                      id="upload"
                      class="account-file-input"
                      hidden
                      accept="image/png, image/jpeg" />
                  </label>
                  <button type="button" class="btn btn-label-secondary account-image-reset mb-4">
                    <i class="icon-base ti tabler-reset d-block d-sm-none"></i>
                    <span class="d-none d-sm-block">Reset</span>
                  </button>

                  <div>Allowed JPG, GIF or PNG. Max size of 800K</div>
                </div>
              </div>
            </div> --}}
            <div class="card-body pt-4">
              {{-- <form id="formAccountSettings" method="GET" onsubmit="return false"> --}}

                <form method="post" action="" enctype="multipart/form-data">
                    @csrf


                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                <div class="row gy-4 gx-6 mb-6">

                    <div class="col-md-6">
                    <label for="email" class="form-label">E-mail</label>
                    <input class="form-control" type="email" value={{ $profileData->email}} name="email"/>
                  </div>

                  <div class="col-md-6">
                    <label class="form-label" for="phoneNumber">Phone Number</label>
                    <div class="input-group input-group-merge">

                      <input
                        type="text"
                        name="phone"
                        value="{{$profileData->phone}}" class="form-control"/>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <label for="address" class="form-label">Address</label>
                    <input type="text" class="form-control"  name="address"  value="{{ $profileData->address }}" />
                  </div>
                  <div class="col-md-6">
                    <label for="city" class="form-label">City </label>
                    <input class="form-control" type="text" name="city"  value="{{ $profileData->city }}" />
                  </div>

                  <div class="col-md-6">
                    <label class="form-label" for="country">Country</label>
                  <input class="form-control" type="text"  name="country"  value="{{ $profileData->country }}"/>
                  </div>


                  <div class="col-md-6" style="padding-top: 40px">
                    <input class="form-check-input" type="checkbox" value=""
                                        id="customCheckTemp4">
                                    <span class=" mb-0">Married</span>
                                    <input class="form-check-input" type="checkbox" name="martal_status"
                                        id="customCheckTemp4">
                                    <span class=" mb-0">Single</span>
                  </div>
                </div>
                <div class="mt-2">
                  <button type="submit" class="btn btn-primary me-3">Save changes</button>
                  <button type="reset" class="btn btn-label-secondary">Cancel</button>
                </div>
              </form>
            </div>

          </div>
 <!-- End ProfileAccount -->

      </div>
    </div>
  </div>
 <!-- / Content -->



    {{-- <!-- JAVASCRIPT TO PREVIEW IMAGE --> --}}
    <script type="text/javascript">
        $(document).ready(function() {
            $('#image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {

                    $('#showImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>


@endsection
