@extends('layouts.admin.admin_master')
@section('admin_yield')

   <!-- Content -->
   <div class="container-xxl flex-grow-1 container-p-y">
    <!-- Basic Layout -->
    <div class="row mb-6 gy-6">
      <div class="col-xl">
        <div class="card">
          <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Subject List</h5>
            <a href="{{ route('admin.add.subject.category') }}" class="btn create-new btn-primary waves-effect waves-light" tabindex="0" aria-controls="DataTables_Table_0" type="button">
                <span><span class="d-flex align-items-center gap-2">
                <span class="d-none d-sm-inline-block">Add New Category</span></span></span>
                </a>
          </div>
          <div class="card-body">


            <div class="row g-6">
                <div class="card">
                    <h5 class="card-header">Student Subject List</h5>
                    <div class="table-responsive text-nowrap">
                      <table class="table table-stiped mainTable">
                        <thead class="table-light">
                          <tr>
                            <th>SL</th>
                            <th>Subject Category</th>
                            <th>Category Image</th>
                            <th>Actions</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            @forelse ( $allData as $key=>$subject_category )

                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{$subject_category->subject_category}}</td>
                                {{-- <td>{{$subject_category->image}}</td> --}}
                                <td><img src="{{ asset($subject_category->image) }}" alt="" style="width: 70px; height:40px;"></td>


                        <td><div class="d-inline-block"><a href="javascript:;" class="btn btn-icon btn-text-secondary rounded-pill waves-effect dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="icon-base ti tabler-dots-vertical"></i></a><ul class="dropdown-menu dropdown-menu-end m-0"><li><a href="javascript:;" class="dropdown-item">Details</a></li><li><a href="{{ route('admin.edit.subject.category', $subject_category->id) }}" class="dropdown-item">Edit</a></li><div class="dropdown-divider"></div><li><a href="javascript:;" class="dropdown-item text-danger delete-record">Delete</a></li></ul></div><a href="javascript:;" class="btn btn-icon btn-text-secondary rounded-pill waves-effect item-edit"><i class="icon-base ti tabler-pencil"></i></a></td>
                            </tr>
                        @empty
                        <tr>
                          <td colspan="6"> No Data!</td>
                        </tr>
                            @endforelse ()
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>


         </div>
        </div>
     </div>
  </div>
</div>








              @endsection
