@extends('layouts.admin.master')

@section('admin_main_body')


    <!--CDN support JQuery from w3 schools TK-- To show images-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>



    <div class="container-fluid">

        <!-- Start::page-header -->
        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">Manage</h1>
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="javascript:void(0);">
                            File Categories
                        </a>
                    </li>
                    <li class="breadcrumb-item" aria-current="page"><a href="javascript:void(0);">File</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Create New Category</li>
                </ol>
            </div>
            <div>
                <a href="{{ route('admin.view.file.categories') }}"
                    class="btn btn-primary-light btn-wave me-2 waves-effect waves-light">
                    <i class="bx bx-building align-middle"></i> View File Categories
                </a>
                <button class="btn btn-secondary-light btn-wave me-0 waves-effect waves-light">
                    <i class="ri-upload-cloud-line align-middle"></i> Export Report
                </button>
            </div>
        </div>
        <!-- End::page-header -->

        <!-- Start::row-1 -->
        <div class="row mb-5">
            <div class="col-xl-3">
                <div class="card custom-card">
                    <div class="card-body">
                        <ul class="nav nav-tabs flex-column nav-tabs-header mb-0" role="tablist">
                            <li class="nav-item m-1">
                                <a class="nav-link active" data-bs-toggle="tab" role="tab" aria-current="page"
                                    href="#add_new_faculty" aria-selected="true">Create New File Category</a>
                            </li>
                            <li class="nav-item m-1">
                                <a class="nav-link" data-bs-toggle="tab" role="tab" aria-current="page"
                                    href="#view_faculty" aria-selected="true">View File Categories</a>
                            </li>

                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xl-9">
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="tab-content">

                            <div class="tab-pane show active" id="add_new_faculty" role="tabpanel">


                                <form method="post" action="{{ route('admin.store.file.category') }}"
                                    enctype="multipart/form-data">
                                    @csrf

                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif


                                    <div class="p-sm-3 p-0">
                                        <h6 class="fw-medium mb-3"> <b> Create File Category</b></h6>

                                        <div class="row gy-4 mb-4">
                                            <div class="col-xl-12">
                                                <label for="first-name" class="form-label">Name</label>
                                                <input type="text" name="category_name" class="form-control"
                                                    id="category_name" placeholder="Enter File Category Name">
                                            </div>


                                            <b> <span class="d-none d-sm-block">Category Front Image (optional)</span></b>

                                            <div class="p-sm-3 p-0">

                                                <div class="mb-4 d-sm-flex align-items-center">
                                                    <div class="mb-0 me-5"> <span class="avatar avatar-xxl avatar-square">
                                                            <img id="showFileCategoryImage"
                                                                src="{{ asset('backend/assets/images/faces/9.jpg') }}"
                                                                alt="">
                                                            <span class="badge rounded-pill bg-primary avatar-badge">
                                                                <input type="file" name="category_image"
                                                                    class="position-absolute w-150 h-1150 op-0"
                                                                    id="category_image"> <i class="fe fe-camera"></i> </span>
                                                        </span>
                                                        <span class="d-none d-sm-block">click on Camera icon to Select Image
                                                        </span>
                                                    </div>
                                                    {{-- <div class="btn-group">
                    <button class="btn btn-primary">Save Change</button>
                 <button class="btn btn-light">Remove</button>
                </div> --}}


                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xl-3">
                                                    <div class="mb-4 d-sm-flex align-items-center">
                                                        <div class="form-check form-switch"> <input class="form-check-input"
                                                                type="checkbox" name="status"  role="switch" id="switch-sm" value="1"> <label
                                                                class="form-check-label" for="switch-sm">Status</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-3">
                                                    <div class="mb-4 d-sm-flex align-items-center">
                                                        <div class="form-check form-switch">
                                                            <input class="form-check-input"  name="is_trending" type="checkbox" role="switch"
                                                                id="switch-sm" value="0"> <label class="form-check-label"
                                                                for="switch-sm">Is Trending</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- <div class="col-xl-12">
                                                <label class="form-label">Description</label>
                                                <div class="input-group mb-3">

                                                    <textarea name="description" class="form-control" id="exampleFormControlTextarea1" rows="3"
                                                        placeholder="About The Faculty / Dept"></textarea>
                                                </div>
                                            </div> --}}



                                        </div>

                                        <div class="row gy-4 mb-4">

                                            <div class="float-end">

                                                <button type="submit" class="btn btn-primary m-1">
                                                    Save Changes
                                                </button>
                                            </div>


                                        </div>
                                    </div>

                                </form>


                            </div>
                            <div class="tab-pane" id="view_faculty" role="tabpanel">
                                <div class="row gy-3">
                                    <div class="col-xxl-12">
                                        <h6 class="fw-medium mb-3" style="padding-bottom: 20px"> <b> View File Categories</b></h6>
                                        <div class="card custom-card shadow-none mb-0 border">
                                            <div class="card-body">




                                                <div class="table-responsive">
                                                    <table class="table text-nowrap">
                                                        <thead class="table-secondary">
                                                            <tr>
                                                                <th>SL</th>
                                                                <th>File Category</th>
                                                                <th>Image</th>
                                                                <th>Action </th>
                                                                {{-- <th>Actions</th> --}}
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            {{-- @forelse ($allData as $key=>$faculty)
                                             <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $faculty->faculty }}</td>
                                    <td>{{ $faculty->faculty_code }}</td>
                                      <td>{{ $faculty->faculty_head }}</td>
                                                             <td>
                                        <div class="d-inline-block">
                                            <a href="javascript:;"
                                                class="btn btn-icon btn-text-secondary rounded-pill waves-effect dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown"><i
                                                    class="icon-base ti tabler-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu dropdown-menu-end m-0">
                                                <li>
                                                    <a href="{{ route('admin.edit.faculty', $faculty->id) }}"
                                                        class="dropdown-item">Edit</a>
                                                </li>
                                                <div class="dropdown-divider"></div>
                                                <li><a href="{{ route('admin.delete.faculty', $faculty->id) }}"
                                                        class="dropdown-item text-danger delete-record"
                                                        id="delete">Delete</a></li>
                                            </ul>
                                        </div>
                                        <a href="javascript:;"
                                            class="btn btn-icon btn-text-secondary rounded-pill waves-effect item-edit"><i
                                                class="icon-base ti tabler-pencil"></i>
                                        </a>

                                    </td>
                                                         </tr>
                            @empty
                                <tr>
                                    <td colspan="3"> No Data!</td>
                                </tr>
                            @endforelse () --}}
                                                        </tbody>

                                                    </table>

                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!--End::row-1 -->

    </div>































    {{-- @php
   $allData= App\Models\SchoolSubjects::all();
@endphp --}}




    </div> <!-- Col-->

    </div> <!-- Row- -->
    </div> <!-- Card body -->
    </div> <!-- Card -->
    </div> <!-- Col -->
    </div> <!-- Row mb-6 -->
    </div>



    {{-- Load image TK --}}
    <script type="text/javascript">
        $(document).ready(function() {
            $('#category_image').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#showFileCategoryImage').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            });
        });
    </script>



@endsection
