@extends('layouts.admin.master')

@section('admin_main_body')
    <!-- Content -->

<!-- Page Header -->
    <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
        <div>
            <h4 class="page-title fw-medium fs-18 mb-2">View File Category</h4>
            <div class="">
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">Manage File</a></li>
                        <li class="breadcrumb-item"><a href="javascript:void(0);">Category</a></li>
                        <li class="breadcrumb-item active" aria-current="page">File Caegory</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="btn-list">
            <a class="btn btn-primary-light btn-wave me-2" href="{{ route('admin.add.file.category') }}">
                <i class="bx bx-crown align-middle" ></i>Create File Category
            </a>
            <a class="btn btn-secondary-light btn-wave me-0" href="">
                <i class="bx bx-arrow-back align-middle"></i> Back
            </a>

        </div>
    </div>
    <!-- Page Header Close -->

     <div class="card-body">



        <div class="card custom-card">
            <div class="card-header justify-content-between">
                <div class="card-title">File Categories</div>
                <div class="prism-toggle">
                    <button class="btn btn-sm btn-primary-light">Faculty Details<i
                            class="ri-check-line ms-2 d-inline-block align-middle"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table text-nowrap">
                        <thead class="table-secondary">
                           <tr>
                            <th>SL</th>
                            <th>File Category</th>
                            <th>Category Image</th>
                            <th>Actions</th>
                          </tr>
                        </thead>
                        <tbody>
                             @forelse ( $fileCategories as $key=>$file_category )

                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{$file_category->category_name}}</td>

                                <td><img src="{{ asset($file_category->category_image) }}" alt="" style="width: 70px; height:40px;"></td>

                                    <td>
                                        <div class="d-inline-block">
                                            <a href="javascript:;"
                                                class="icon-base ti ti-dots-vertical"
                                                data-bs-toggle="dropdown">
                                            </a>
                                            <ul class="dropdown-menu dropdown-menu-end m-0">

                                                <li>
                                                    <a href="{{ route('admin.edit.subject.category', $subject_category->id) }}"
                                                        class="dropdown-item">Edit</a>
                                                </li>
                                                <div class="dropdown-divider"></div>
                                                <li><a href="{{ route('admin.delete.subject.category', $subject_category->id) }}"
                                                        class="dropdown-item text-danger delete-record"
                                                        id="delete">Delete</a></li>
                                            </ul>
                                        </div>
                                        <a href="javascript:;"
                                            class="btn btn-icon btn-text-secondary rounded-pill waves-effect item-edit"><i
                                                class="icon-base ti tabler-pencil"></i>
                                        </a>

                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4"> No Data!</td>
                                </tr>
                            @endforelse ()
                        </tbody>

                    </table>

                </div>
            </div>


                 </div>

                    </div>




                </div>
            </div>
        </div>
    </div>
@endsection
