
@extends('layouts.admin.master')

@section('admin_main_body')


 <!-- Page Header -->
    <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
        <div>
            <h4 class="page-title fw-medium fs-18 mb-2">Edit Student</h4>
            <div class="">
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">Student Register Edit</a></li>
                        <li class="breadcrumb-item"><a href="javascript:void(0);">Edit Student</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Edit</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="btn-list">
            <a class="btn btn-primary-light btn-wave me-2" href="{{ route('admin.view.student.list') }}">
                <i class="bx bx-crown align-middle" ></i> View Students
            </a>
            <a class="btn btn-secondary-light btn-wave me-0" href="">
                <i class="bx bx-arrow-back align-middle"></i> Back
            </a>

        </div>
    </div>
    <!-- Page Header Close -->

    <!-- Start:: row-1 -->
    <div class="row">
        <div class="col-xl-12">
            <div class="card custom-card">
                <div class="card-header justify-content-between">
                    {{-- <div class="card-title">
                        <h6> Register New Student</h6>
                    </div> --}}

                </div>

       <form method="post" action="{{route('admin.update.student.register')}}" enctype="multipart/form-data">

        @csrf
 <input type="hidden" name ="id"  value ="{{$data->id}}" >

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
       <h6><b>1. Personal Information</b></h6>



                <div class="card-body">
                    <div class="row gy-4">


                        <div class="col-6">
                            <label for="input-label" class="form-label">First Name<span class="text-danger"> *</span></label>
                            <input type="text" name="first_name" class="form-control"value="{{$data->first_name}}">
                        </div>
                        <div class="col-6">
                            <label for="input-label" class="form-label">Last Name <span class="text-danger"> *</span></label>
                            <input type="text" name="last_name" class="form-control"  value="{{ $data->last_name }}">
                        </div>


                        <div class="row g-3">
                            <div class="col-sm-6">
                                <label for="input-label"  class="form-label">Email<span class="text-danger"> *</span></label>
                                <input type="email" name="email" id="email" class="form-control" value="{{ $data->email }}"
                                    aria-label="Email">
                            </div>

                            <div class="col-3">
                                <label for="input-label" class="form-label">Birth Date <span class="text-danger"> </span></label>
                                <input type="date" name="dob" id="dob" class="form-control" value="{{ $data->student->dob }}"
                                    aria-label="Birth Date">
                            </div>


                                      <div class="col-3">
                         <label for="input-datet" class="form-label">Gender</label>
                                    <select class="form-select" id="select" name="gender" required="">
                                        <option selected="" disabled="" value="">Select Gender</option>
                        <option value="Male" {{ ($data->student->gender == 'male')? 'selected':'' }}>Male</option>
                        <option value="Female" {{ ($data->student->gender == 'female')? 'selected':'' }}>Female</option>
                                      </select>
                            </div>
                         <div class="col-3">
                                <label for="input-label" class="form-label">Admission Date <span class="text-danger"> </span></label>
                                <input type="date" name="admission_date" id="join_date" class="form-control" value="{{ $data->student->admission_date }}"
                                    aria-label="Admission Date">
                            </div>

                       <div class="col-3">
                                <label for="input-label" class="form-label">Student Number <span class="text-danger"> </span></label>
                                <input type="text" name="student_no" id="student_no" value="{{ $data->student->id_no }}" class="form-control"  readonly
                                    aria-label="student_no">
                            </div>


                        </div>

                        {{-- <div class="row " style ="padding-top: 10px;">
                            <div class="col-12 ">

                            </div>
                            </div> --}}
            <hr class="my-6 mx-n6" style="padding-top:20px " />

              <h6><b>2. Profile Data</b></h6>

                        {{-- <div class="card-header justify-content-between">
                            <div class="card-title">
                                <h6>  Add Student Profile </h6>
                            </div>

                        </div> --}}


                        <div class="row g-3">
                            <div class="col-sm-4">
                                <input type="text" name="address" id="address" class="form-control" value="{{ $data->student->address }}"
                                    aria-label="City">
                            </div>
                                <div class="col-4">
                                <input type="text" name="post_code"  class="form-control" value="{{ $data->student->post_code }}"
                                    aria-label="State">
                            </div>
                            <div class="col-4">
                                <input type="text" name="city" id="city" class="form-control" value="{{ $data->student->city }}">
                            </div>
                                <div class="col-4">
                                <input type="text" name="region" id="region" class="form-control" value="{{ $data->student->region }}"
                                    aria-label="State">
                            </div>
                            <div class="col-4">
                                <input type="text" name="country" id="country" class="form-control" value="{{ $data->student->country}}"
                                    aria-label="Zip">
                            </div>
                                <div class="col-4">
                                <input type="text" name="phone" id="phone" class="form-control" value="{{ $data->student->phone}}"
                                    aria-label="Zip">
                            </div>


                            <div class="col-sm-4">
                                {{-- <label for="input-datet" class="form-label">Guardian / Kin</label> --}}
                                <input type="text"  name="kin_name"    class="form-control" value="{{ $data->student->kin_name}}"
                                    aria-label="City">
                            </div>
                            <div class="col-4">
                                 {{-- <label for="input-datet" class="form-label">Guardian email</label> --}}
                                <input type="email" name="kin_email"  class="form-control" value="{{ $data->student->kin_email}}"
                                    aria-label="State">
                            </div>
                            <div class="col-4">
                                {{-- <label for="input-datet" class="form-label">Guardian Contact</label> --}}
                                <input type="text" name="kin_tel" id="guardian_tel" class="form-control" value="{{ $data->student->kin_tel }}"
                                    aria-label="Zip">
                            </div>

                        </div>





                        <div class="row " style ="padding-top: 15px;">
                            <div class="col-12 ">

                            </div>
                            </div>

                            {{-- <div class="card-header justify-content-between">
                                <div class="card-title">
                                    <h6>  Student Academics </h6>
                                </div> --}}


                            {{-- </div> --}}
                               <hr class="my-6 mx-n6" style="padding-top:20px " />
   <h6><b>3. Academics</b></h6>

                                {{-- <div class="row " style ="padding-top: 15px;">
                                    <div class="col-12 ">

                                    </div>
                                    </div> --}}

                       <div class="row g-3">
                            <div class="col-sm-4">

                                    <label for="input-label" class="form-label">Pursuing Course, Degree/Major<span class="text-danger">* </span></label>
                                <select class="form-control" name="student_degree_id" required="">

                             @foreach ( $degrees as $degree)
                          <option value="{{$degree->id}}"{{ ($data->student->student_degree_id == $degree->id )? "selected":"" }}>{{$degree->degree_name}}</option>
                          @endforeach
                              </select>

                            </div>

                            <div class="col-4">
                                {{-- <span class="text-danger">Department/ Institute / Faculty *</span> --}}
                                  <label for="input-label" class="form-label"> Department/ Institute / Faculty <span class="text-danger">* </span></label>
                                <select class="form-control" name="faculty_id" required="">


                                    @foreach ( $faculties as $faculty)
                                    <option value="{{$faculty->id}}"{{ ($data->student->faculty_id == $faculty->id )? "selected":"" }}>{{$faculty->faculty }}</option>
                                    {{-- <option value="{{$faculty->$faculty}}">{{$faculty->$faculty}}</option> --}}
                                    @endforeach

                                  </select>
                            </div>

                            <div class="col-4">

                               <label for="input-label" class="form-label">Select Class<span class="text-danger">* </span></label>
                                <select class="form-control" name="student_class_id" required="">


                                    @foreach ($classes as $class)
                                    {{-- <option value="{{$class->class_name}}">{{$class->class_name}}</option> --}}
                                      <option value="{{$class->id}}"{{ ($data->student->student_class_id == $class->id)? "selected":"" }} >{{$class->class_name}}</option>
                                   @endforeach
                              </select>
                            </div>


                        </div>

                        <div class="col-4">

                             <label for="input-label" class="form-label">Current Academic Year<span class="text-danger">* </span></label>
                            <select class="form-control" name="academic_year_id" required="">
                            @foreach ($years as $year)
                            <option value="{{$year->id}}"{{ ($data->student->academic_year_id == $year->id )? "selected":"" }} >{{$year->academic_year}}</option>
                            @endforeach
                               </select>
                        </div>
                           <div class="col-4">
                          <label for="input-file" class="form-label">Upload Document</label>
                            <input class="form-control" name="filename" type="file" id="file">
                        </div>

                           <div class="col-4">
                            <label for="text" class="form-label">Notes</label>
                            <input class="form-control" type="text" name="notes" value="{{ $data->student->notes}}">
                        </div>
                        </div>

                        <div class="row " style ="padding-top: 25px;">
                            <div class="col-12 ">

                            </div>
                            </div>

                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="d-md-flex d-grid align-items-center gap-3">
                                    <button type="submit" class="btn btn-primary px-4">Update Changes</button>
                                    <button type="reset" class="btn btn-light px-4">Cancel</button>
                                </div>
                            </div>
                        </div>
                        </form>

                        </div>
                    </div>
                </div>
</div>
</div>

   <!-- Content -->
@endsection
