@extends('layouts.admin.master')

@section('admin_main_body')


   <div class="container-fluid">
                <!-- Page Header -->
                <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
                    <div>
                        <h1 class="page-title fw-medium fs-18 mb-2">Users</h1>
                        <div class="">
                            <nav>
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Tables</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Data Tables</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <div class="btn-list">
                        <a href="{{ route('admin.add.user') }}">
                        <button class="btn btn-primary-light btn-wave me-2">
                            <i class="bx bx-crown align-middle"></i> Add New User
                        </button>
                        </a>
                        <button class="btn btn-secondary-light btn-wave me-0">
                            <i class="ri-upload-cloud-line align-middle"></i> Export Report
                        </button>
                    </div>
                </div>
                <!-- Page Header Close -->

                <div class="alert alert-secondary alert-dismissible fs-15 fade show mb-4">
                    Search <strong class="text-fixed-black">For Anything</strong> Enter your request <strong class="text-fixed-black">in the search field</strong> Example name or filter class.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"><i class="bi bi-x"></i></button>
                </div>


                <!-- Start::row-1 -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card custom-card">
                            <div class="card-header">
                                <div class="card-title">
                                    Users
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="datatable-basic" class="table table-bordered text-nowrap w-100">
                                    <thead class="table-primary">
                                    <tr>
                                    <th>Last Name</th>
                                    <th>First Name</th>
                                    <th>email</th>
                                    <th>Membership</th>
                                    {{-- <th>class</th>
                                    <th>Faculty/Institute</th> --}}
                                    <th>Action</th>
                                    </tr>
                                        </thead>
                                         <tbody>
                    @forelse ( $users as $user )

                        <tr>
                    <td>{{ $user->last_name }} </td>
                    <td>{{ $user->first_name }} </td>
                    <td>{{ $user->email }} </td>
                    <td>{{ $user->student->student_class->class_name }} </td>
                     {{-- <td>{{ $user->student->major }} </td> --}}
                     <td>{{ $user->student->degree->degree_name }} </td>


                    <td>{{ $user->student->faculty->faculty }} </td>

                    <td>

                        <div class="d-inline-block"><a href="javascript:;" class="btn btn-icon btn-text-secondary rounded-pill waves-effect dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                            {{-- <i class="icon-base ti tabler-dots-vertical"></i> --}}

                         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                          <path d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0"/>
                        </svg>

                        </a>
                        <ul class="dropdown-menu dropdown-menu-end m-0">
                        <li>
                            <a href="{{ route('admin.view.user.details',$user->id) }}" class="dropdown-item">Details
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('admin.edit.user',$user->id ) }}" class="dropdown-item">Edit</a>
                        </li>
                        <div class="dropdown-divider">
                        </div>
                        <li>
                            <a href="{{ route('admin.delete.user',$user->id) }}" class="dropdown-item text-danger delete-record">Delete</a>
                        </li>
                    </ul>
                </div>
                <a href="" class="btn btn-icon btn-text-secondary rounded-pill waves-effect item-edit">
                    <i class="icon-base ti tabler-pencil"></i>
                </a>
            </td>
                        </tr>
                    @empty
                    <tr>
                      <td colspan="3"> No Data!</td>
                    </tr>
                        @endforelse ()
                    </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--End::row-1 -->

     </div>








@endsection
