@extends('layouts.admin.master')

@section('admin_main_body')

    <!-- Start::app-content -->

    <div class="container-fluid">

        <!-- Page Header -->
        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">File Manager</h1>
                <div class="">
                    <nav>
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Pages</a></li>
                            <li class="breadcrumb-item active" aria-current="page">File Manager</li>
                        </ol>
                    </nav>
                </div>
            </div>
            <div class="btn-list">
                <button class="btn btn-primary-light btn-wave me-2">
                    <i class="bx bx-crown align-middle"></i> Plan Upgrade
                </button>
                <button class="btn btn-secondary-light btn-wave me-0">
                    <i class="ri-upload-cloud-line align-middle"></i> Export Report
                </button>
            </div>
        </div>
        <!-- Page Header Close -->

        <!-- Start:: row-1 -->
        <div class="row">

        </div>

        <div class="col-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body p-0">
                    <div class="file-manager-folders">
                        @if ($file_categories->isEmpty())
                            <div
                                class="d-flex p-3 flex-wrap gap-2 align-items-center justify-content-between border-bottom">
                                <div class="flex-fill">
                                    <h6 class="fw-medium mb-0">Start By Creating Folders To Upload Files</h6>
                                </div>

                            </div>
                        @endif


                        <div class="card-body">

                            <!---Modal create Folder-->


                            <div class="btn-list">
                                <button type="button" class="btn btn-primary mb-1" data-bs-toggle="modal"
                                    data-bs-target="#formfoldermodal" data-bs-whatever="@mdo">Create New Folder </button>
                                {{-- <button type="button" class="btn btn-secondary mb-1" data-bs-toggle="modal"
                                data-bs-target="#formfilemodal" data-bs-whatever="@mdo">Upload New File</button> --}}
                            </div>
                            <div class="modal fade" id="formfoldermodal" tabindex="-1" aria-labelledby="exampleModalLabel"
                                aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h6 class="modal-title" id="exampleModalLabel">New Folder</h6>

                                        </div>
                                        <div class="modal-body">
                                            <form method="post" action="{{ route('admin.store.file.folder') }}">
                                                @csrf

                                                @if ($errors->any())
                                                    <div class="alert alert-danger">
                                                        <ul>
                                                            @foreach ($errors->all() as $error)
                                                                <li>{{ $error }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                @endif
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">Folder Name:</label>
                                                    <input type="text" name="folder_name" class="form-control"
                                                        id="recipient-name">
                                                </div>
                                                {{-- <div class="mb-3">
                                                            <label for="message-text"
                                                                class="col-form-label">Message:</label>
                                                            <textarea class="form-control" id="message-text"></textarea>
                                                        </div> --}}

                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                        </form>
                                    </div>
                                </div>
                            </div>




                            <div class="modal fade" id="formfilemodal" tabindex="-1" aria-labelledby="exampleModalLabel"
                                aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h6 class="modal-title" id="exampleModalLabel">Upload New File</h6>

                                        </div>
                                        <div class="modal-body">
                                            <form method="post" action="" enctype="multipart/form-data">
                                                @csrf

                                                @if ($errors->any())
                                                    <div class="alert alert-danger">
                                                        <ul>
                                                            @foreach ($errors->all() as $error)
                                                                <li>{{ $error }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                @endif
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">file Name:</label>
                                                    <input type="file" name="file_name" class="form-control"
                                                        id="recipient-name">
                                                </div>
                                                {{-- <div class="mb-3">
                                                            <label for="message-text"
                                                                class="col-form-label">Choose Folder:</label>
                                                            <textarea class="form-control" id="message-text"></textarea>
                                                        </div> --}}


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                </div>

                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>





                            <!---Modal End create Folder-->
                        </div>














                        <!-- Start::row-1 -->
                        <div class="row mb-5">

                            <div class="col-xl-12">
                                <div class="card custom-card">
                                    <div class="card-body">
                                        <div class="tab-content">

                                            @if ($file_categories == null || $file_categories->isEmpty())
                                                <div class="d-flex mb-3 align-items-center justify-content-between">
                                                    <p class="mb-0 fw-medium fs-14"><b>Create New Folder</b></p>
                                                    <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View
                                                        All<i class="ti ti-arrow-narrow-right ms-1"></i> </a>
                                                </div>
                                            @endif


                                            @if (!$file_categories->isEmpty())
                                                <div class="d-flex mb-3 align-items-center justify-content-between">
                                                    <p class="mb-0 fw-medium fs-14"><b>Create New Folder Or Browse To Manage
                                                            Files</b></p>
                                                    <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View
                                                        All<i class="ti ti-arrow-narrow-right ms-1"></i> </a>
                                                </div>
                                            @endif


                                            @if ($file_categories == null || $file_categories->isEmpty())
                                                <span class="fs-12 text-muted">No Data Found!</span>
                                            @endif


                                            @if (!$file_categories->isEmpty())
                                                <div class="row mb-3">

                                                    @foreach ($file_categories as $file_category)
                                                        <div class="col-xxl-3 col-xl-6 col-lg-6 col-md-6">

                                                            <div class="card custom-card shadow-none">
                                                                <div class="card-body">

                                                                    <a
                                                                        href="{{ route('admin.view.file.sub.folders', $file_category->id) }}">

                                                                        <div
                                                                            class="mb-4 folder-svg-container d-flex flex-wrap justify-content-between align-items-top">

                                                                            <div class="svg-warning text-warning">
                                                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                                                    viewBox="0 0 256 256">
                                                                                    <rect width="256" height="256"
                                                                                        fill="none" />
                                                                                    <path
                                                                                        d="M69.77,112H208V88a8,8,0,0,0-8-8H130.67a8,8,0,0,1-4.8-1.6L98.13,57.6a8,8,0,0,0-4.8-1.6H40a8,8,0,0,0-8,8V208l30.18-90.53A8,8,0,0,1,69.77,112Z"
                                                                                        opacity="0.2" />
                                                                                    <path
                                                                                        d="M32,208V64a8,8,0,0,1,8-8H93.33a8,8,0,0,1,4.8,1.6l27.74,20.8a8,8,0,0,0,4.8,1.6H200a8,8,0,0,1,8,8v24"
                                                                                        fill="none"
                                                                                        stroke="currentColor"
                                                                                        stroke-linecap="round"
                                                                                        stroke-linejoin="round"
                                                                                        stroke-width="16" />
                                                                                    <path
                                                                                        d="M32,208l30.18-90.53A8,8,0,0,1,69.77,112H232a8,8,0,0,1,7.59,10.53L211.09,208Z"
                                                                                        fill="none"
                                                                                        stroke="currentColor"
                                                                                        stroke-linecap="round"
                                                                                        stroke-linejoin="round"
                                                                                        stroke-width="16" />
                                                                                </svg>

                                                                            </div>
                                                                            <div>
                                                                                <div class="dropdown">
                                                                                    <a href="javascript:void(0);"
                                                                                        data-bs-toggle="dropdown"
                                                                                        aria-expanded="false">
                                                                                        <i
                                                                                            class="ri-more-2-fill fw-semibold text-muted"></i>
                                                                                    </a>
                                                                                    <ul class="dropdown-menu">
                                                                                        <li><a class="dropdown-item"
                                                                                                href="javascript:void(0);">View</a>
                                                                                        </li>
                                                                                        <li><a class="dropdown-item"
                                                                                                href="javascript:void(0);">Rename</a>
                                                                                        </li>
                                                                                        <li><a class="dropdown-item"
                                                                                                href="javascript:void(0);">Delete
                                                                                                Folder</a></li>
                                                                                    </ul>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </a>


                                                                    <p class="fs-14 fw-medium mb-1 lh-1">
                                                                        <a
                                                                            href="javascript:void(0);">{{ $file_category->folder_name }}</a>
                                                                    </p>
                                                                    <div
                                                                        class="d-flex align-items-center justify-content-between flex-wrap">
                                                                        <div>
                                                                            <span class="text-muted fs-12">
                                                                                246 Files
                                                                            </span>
                                                                        </div>
                                                                        <div>
                                                                            <span class="text-default fw-medium">
                                                                                214.32MB
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                            @endif

                                        </div>


                                    </div>


                                </div>
                            </div>

                        </div>

                    </div>


                    @if ($all_files == null || $all_files->isEmpty())
                        <span class="fs-12 text-muted">File Database is Empty!</span>
                    @endif


                    @if (!$all_files->isEmpty())
                        <!---File Management-->
                        <div class="d-flex mb-3 align-items-center justify-content-between">
                            <p class="mb-0 fw-medium fs-14">Recent Files</p>
                            <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View All<i
                            class="ti ti-arrow-narrow-right ms-1"></i> </a>
                        </div>
                        <div class="row">





                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
    </div>
    </div>
    <!-- End:: row-1 -->

    </div>

    <!-- End::app-content -->
@endsection
