<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\PasswordController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Auth\VerifyEmailController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Auth\ConfirmablePasswordController;
use App\Http\Controllers\Backend\User\UserRegisterController;
use App\Http\Controllers\Backend\Admin\AdminProfileController;
use App\Http\Controllers\Backend\Admin\AdminPasswordController;
use App\Http\Controllers\Backend\FileManagement\FileController;
use App\Http\Controllers\Auth\EmailVerificationPromptController;
use App\Http\Controllers\Backend\Admin\AdminDashboardController;
use App\Http\Controllers\Backend\FileManagement\FolderController;
use App\Http\Controllers\Admin\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Backend\FileManagement\SubFolderController;
use App\Http\Controllers\Backend\FileManagement\FileUploadController;
use App\Http\Controllers\Auth\EmailVerificationNotificationController;
use App\Http\Controllers\Backend\FileManagement\FileManagementController;






/***
 * --------------------------------------------------------------
 * Admin Frontpage Login Authentication And Password Related Routes
 * --------------------------------------------------------------
 */

Route::group(["middleware" => "guest:admin",  "prefix" => "admin", "as" => "admin."], function () {


    Route::get('login', [AuthenticatedSessionController::class, 'create'])->name('login');

    Route::post('login', [AuthenticatedSessionController::class, 'store'])->name('login.store');


    Route::get('forgot-password/request', [PasswordResetLinkController::class, 'create'])->name('password.request');

    Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])->name('password.email');


    //TK created a redirect after reset
    Route::get('password/reset-link/sent', [PasswordResetLinkController::class, 'passwordEmailSent'])->name('password.email.sent');


    Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])->name('password.reset');

    Route::post('reset-password', [NewPasswordController::class, 'store'])->name('password.store');
});









/***
 * ----------------------------------------------
 * Admin Authentication And Password Related Routes
 * ---------------------------------------------
 */

Route::group(["middleware" => "auth:admin", "prefix" => "admin", "as" => "admin."], function () {
    Route::get('verify-email', EmailVerificationPromptController::class)->name('verification.notice');


    Route::get('verify-email/{id}/{hash}', VerifyEmailController::class)
        ->middleware(['signed', 'throttle:6,1'])
        ->name('verification.verify');


    Route::post('email/verification-notification', [EmailVerificationNotificationController::class, 'store'])
        ->middleware('throttle:6,1')
        ->name('verification.send');


    Route::get('confirm-password', [ConfirmablePasswordController::class, 'show'])->name('password.confirm');

    Route::post('confirm-password', [ConfirmablePasswordController::class, 'store']);

    Route::put('password', [PasswordController::class, 'update'])->name('password.update');

    Route::post('logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');








    /***
     * -----------------------------------
     * Admin Dashboard Related Routes
     * -------------------------------------
     */
    Route::get('dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');

    //Route::get('app/settings', [AdminDashboardController::class, 'viewSettings'])->name('settings.view');


    /***
     * -----------------------------------
     * Admin Change Password Related Routes
     * -------------------------------------
     */
    Route::get('/profile/password/change', [AdminPasswordController::class, 'changeAdminPassword'])->name('profile.password.change');

    Route::post('/profile/password/update', [AdminPasswordController::class, 'adminPasswordUpdate'])->name('update.password');

    Route::post('/profile/password/update/new', [AdminPasswordController::class, 'updateNewPassword'])->name('update.new.password');



    /***
     * -----------------------------------
     * Admin Profile Related Routes
     * -----------------------------------
     */

    //profile update controller
    Route::get('/profile/view', [AdminProfileController::class, 'viewAdminProfile'])->name('view.profile');

    Route::get('/profile/edit', [AdminProfileController::class, 'editAdminProfile'])->name('edit.profile');

    Route::get('/profile/picturre/edit', [AdminProfileController::class, 'editAdminProfilePicture'])->name('edit.profile.picture');

    Route::post('/profile/update', [AdminProfileController::class, 'adminProfileUpdate'])->name('update.profile');

    //profile picture related controller
    Route::post('/profile/picture/update', [AdminProfileController::class, 'adminProfilePictureUpdate'])->name('update.profile.picture');





    /***
     * --------------------------------------------------------------------------------------------------------------
     *                                      Admin Backend Routes
     * --------------------------------------------------------------------------------------------------------------
     */


    /***
     * ----------------------------------------------------
     *                      File Management
     * ----------------------------------------------------
     */


    //View Dashboard
    Route::get('/file/management/view', [FileManagementController::class, 'index'])->name('view.filemanagement');

    Route::get('/file/management/category/view', [FileManagementController::class, 'viewCategories'])->name('view.file.categories');
    Route::get('/file/management/category/add', [FileManagementController::class, 'addCategory'])->name('add.file.category');
    Route::post('/file/management/category/add', [FileManagementController::class, 'storeCategory'])->name('store.file.category');

    Route::get('/file/management/file/view', [FileManagementController::class, 'viewFiles'])->name('view.files');



  Route::get('/file/management/sub-category/view', [FileManagementController::class, 'viewSubCategories'])->name('view.subcategory.files');



 Route::get('/file/management/folder/view', [FolderController::class, 'viewFolders'])->name('view.file.folders');
 Route::post('/file/management/folder/store', [FolderController::class, 'storeFolder'])->name('store.file.folder');


 Route::get('/file/management/subfolder/{id}', [SubFolderController::class, 'viewSubFolders'])->name('view.file.sub.folders');
 Route::post('/file/management/subfolder/store/{id}', [SubFolderController::class, 'storeSubFolder'])->name('store.sub.folder');



Route::get('/file/management/subfolder/files/view/{id}', [FileController::class, 'viewSubFolderFiles'])->name('view.sub.folder.files');
 Route::post('/file/management/subfolder/files/store/{id}', [FileController::class, 'storeSubFolderFiles'])->name('store.sub.folder.files');

Route::get('/file/management/files/view/all', [FileController::class, 'viewAllFiles'])->name('view.all.files');
 Route::post('/file/management/files/upload/{id}', [FileUploadController::class, 'uploadFiles'])->name('upload.files');


// Route::get('/file/management/files/view/all', [FileController::class, 'viewAllFiles'])->name('view.files');
//  Route::get('/file/management/files/view/{id}', [FileController::class, 'viewiles'])->name('view.files');
//
// Route::post('/file/management/files/upload/{id}', [FileUploadController::class, 'uploadFiles'])->name('upload.files');


Route::get('/user/view', [UserRegisterController::class, 'viewUsers'])->name('view.users');
Route::get('/user/add', [UserRegisterController::class, 'addUser'])->name('add.user');
Route::post('/user/add', [UserRegisterController::class, 'storeUser'])->name('store.new.user');

});
