<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});


Route::get('/index', function () {
    return view('index');
});


Route::get('/admin-login', function () {
    return view('admin.auth.admin_login');

});

Route::get('/admin-login-cover', function () {
    return view('admin.auth.admin_login_cover');
});

Route::get('/admin/login', function () {
    return view('admin.auth.admin_login');
   // return view('version.index');
});




Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});



Route::get('/admin/dashboard', function () {
    return view('admin.dashboard');
})->middleware(['auth', 'verified'])->name('admin.dashboard');






require __DIR__.'/auth.php';

/**
 * Added for admin auth routes
 */
require __DIR__.'/admin.php';
