

@extends('layouts.admin.master')

@section('admin_main_body')

    <!-- Content -->
  <!-- Start::app-content -->

    <div class="container-fluid">

        <!-- Page Header -->
        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">View All Files</h1>
                <div class="">
                    <nav>
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Parent Folder</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Upload Files</li>
                        </ol>
                    </nav>
                </div>
            </div>
            <div class="btn-list">
                <button class="btn btn-primary-light btn-wave me-2">
                    <i class="bx bx-crown align-middle"></i> Parent Folder
                </button>
                <button class="btn btn-secondary-light btn-wave me-0">
                    <i class="ri-upload-cloud-line align-middle"></i> Export Report
                </button>
                  {{-- <a href="{{ route('admin.view.file.folders') }}" class="btn btn-secondary mb-1" >Back</a> --}}
                </div>
            </div>
        </div>
        <!-- Page Header Close -->

        <!-- Start:: row-1 -->
        <div class="row">

        </div>

        <div class="col-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body p-0">
                    <div class="file-manager-folders">
                        <div class="d-flex p-3 flex-wrap gap-2 align-items-center justify-content-between border-bottom">
                            <div class="flex-fill" >
                                <h6 class="fw-medium mb-0" >Upload New File</h6>
                            </div>

                        </div>


                        <div class="card-body">
                  <div class="btn-list">

                                <a href="{{ route('admin.dashboard') }}" type="button" class="btn btn-secondary mb-1" >Upload New File</a>
                </div>


                    {{-- <div class="modal fade" id="formsubfolderfilemodal" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h6 class="modal-title" id="exampleModalLabel">Upload New File</h6>

                                                </div>
                                                <div class="modal-body">

                                         <form method="post" action=""
                                              enctype="multipart/form-data">

                                           @csrf

                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                                        <div class="mb-3">
                                                            <label for="recipient-name"
                                                                class="col-form-label">File Name:</label>
                                                            <input type="file" name="file_name" class="form-control" id="recipient-name">
                                                        </div>


                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                </div>

                                                  </form>
                                            </div>
                                        </div>
                                    </div>





                                </div>














                        <!-- Start::row-1 -->

                    </div> --}}
     </div>

   @if ($all_files == null || $all_files->isEmpty())
            {{-- <span class="fs-12 text-muted">File Database is Empty!</span> --}}






                    <div class="d-flex mb-3 align-items-center justify-content-between">
                        <br> <span class="fs-12 text-muted">File Database is Empty!</span></br>
                        <p class="mb-0 fw-medium fs-14"> Files in database :  is Empty</p>
                        <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View All<i
                                class="ti ti-arrow-narrow-right ms-1"></i> </a>
                    </div>

                        {{-- <h6 class="mb-3">Filepond:</h6> --}}
                        {{-- <div class="row">
                            <div class="col-xl-12">
                                <div class="card custom-card">
                                    <div class="card-header">
                                        <div class="card-title">
                                            Multiple Upload
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <input type="file" class="multiple-filepond" name="filepond" multiple data-allow-reorder="true" data-max-file-size="3MB" data-max-files="6">
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <div class="card custom-card">
                                    <div class="card-header">
                                        <div class="card-title">
                                            Single Upload
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <input type="file" class="single-fileupload" name="filepond" accept="image/png, image/jpeg, image/gif">
                                    </div>
                                </div>
                            </div>
                        </div> --}}


                    </div>

        @endif

        @if (!$all_files->isEmpty())

                    <div class="row">


         <!-- Start::row-1 -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card custom-card">
                            <div class="card-header">
                                <div class="card-title">
                                    All Files In Database
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="datatable-basic" class="table table-bordered text-nowrap w-100">
                                        <thead>
                                            <tr>
                    <th scope="col">File Name</th>
                    <th scope="col">Folder</th>
                    <th scope="col">File Type</th>
                    <th scope="col">Size</th>
                    <th scope="col">Date Modified</th>
                    <th scope="col">Action</th>
                </tr>
                                        </thead>
                                        <tbody>

     @foreach ( $all_files as $key=>$files )
                <tr>

                    {{-- <th scope="row">
                        <div class="d-flex align-items-center">
                            <div class="me-0">
                                <span class="avatar avatar-md svg-primary text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"/><path d="M112,175.67V168a8,8,0,0,0-8-8H48a8,8,0,0,0-8,8v40a8,8,0,0,0,8,8h56a8,8,0,0,0,8-8v-8.82L144,216V160Z" opacity="0.2"/><polyline points="112 175.67 144 160 144 216 112 199.18" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><rect x="40" y="160" width="72" height="56" rx="8" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><polygon points="152 32 152 88 208 88 152 32" opacity="0.2"/><polyline points="152 32 152 88 208 88" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><path d="M176,224h24a8,8,0,0,0,8-8V88L152,32H56a8,8,0,0,0-8,8v88" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/></svg>
                                </span>
                            </div>
                            <div>
                                <a href="javascript:void(0);" data-bs-toggle="offcanvas"
                                data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">VID-00292312-SPK823.mp4</a>
                            </div>
                        </div>
                    </th> --}}
                    <td>{{ $files->file_name }}</td>
                    <td>{{ $files->sub_folder_id }}</td>
                    <td>{{ $files->file_type }}</td>
                    <td>{{ $files->file_size }}</td>

                    <td>{{ $files->file_name }}</td>
                    <td>
                        <div class="hstack gap-2 fs-15">
                            <a href="javascript:void(0);" class="btn btn-icon btn-sm btn-info-light"><i class="ri-eye-line"></i></a>
                            <a href="javascript:void(0);" class="btn btn-icon btn-sm btn-danger-light"><i class="ri-delete-bin-line"></i></a>
                                <a href="javascript:void(0);" class="btn btn-icon btn-sm btn-success-light"><i class="ri-edit-line"></i></a>
                        </div>
                    </td>
                </tr>
                    @endforeach



                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--End::row-1 -->



                               @endif


                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    </div>
    <!-- End:: row-1 -->

    </div>

    <!-- End::app-content -->
@endsection



